/*
 * Decompiled with CFR 0.152.
 */
package org.structr.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.QuoteMode;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class GetCsvHeadersFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_FROM_CSV = "Usage: ${get_csv_headers(source[, delimiter[, quoteChar[, recordSeparator]]])}. Example: ${get_csv_headers('COL1;COL2;COL3\none;two;three')}";
    public static final String ERROR_MESSAGE_FROM_CSV_JS = "Usage: ${{Structr.getCsvHeaders(source[, delimiter[, quoteChar[, recordSeparator]]])}}. Example: ${{Structr.getCsvHeaders('COL1;COL2;COL3\none;two;three')}}";

    public String getName() {
        return "get_csv_headers()";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (!this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 4)) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        try {
            String source = sources[0].toString();
            String delimiter = ";";
            String quoteChar = "\"";
            String recordSeparator = "\n";
            switch (sources.length) {
                case 4: {
                    recordSeparator = (String)sources[3];
                }
                case 3: {
                    quoteChar = (String)sources[2];
                }
                case 2: {
                    delimiter = (String)sources[1];
                    break;
                }
            }
            CSVFormat format = CSVFormat.newFormat((char)delimiter.charAt(0)).withHeader(new String[0]);
            format = format.withQuote(quoteChar.charAt(0));
            format = format.withRecordSeparator(recordSeparator);
            format = format.withIgnoreEmptyLines(true);
            format = format.withIgnoreSurroundingSpaces(true);
            format = format.withQuoteMode(QuoteMode.ALL);
            try (CSVParser parser = new CSVParser((Reader)new StringReader(source), format);){
                Set set = parser.getHeaderMap().keySet();
                return set;
            }
        }
        catch (Throwable t) {
            this.logException(t, "{}: Exception for parameter: {}", new Object[]{this.getName(), this.getParametersAsString(sources)});
            return "";
        }
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_FROM_CSV_JS : ERROR_MESSAGE_FROM_CSV;
    }

    public String shortDescription() {
        return "Parses the given CSV string and returns a list of column headers";
    }
}

