/*
 * Decompiled with CFR 0.152.
 */
package org.structr.csv;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.function.LocalizeFunction;
import org.structr.core.property.DateProperty;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.parser.DatePropertyParser;
import org.structr.web.function.UiFunction;

public class ToCsvFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_TO_CSV = "Usage: ${to_csv(nodes, propertiesOrView[, delimiterChar[, quoteChar[, recordSeparator[, includeHeader[, localizeHeader[, headerLocalizationDomain]]]])}. Example: ${to_csv(find('Page'), 'ui')}";
    public static final String ERROR_MESSAGE_TO_CSV_JS = "Usage: ${{Structr.to_csv(nodes, propertiesOrView[, delimiterChar[, quoteChar[, recordSeparator[, includeHeader[, localizeHeader[, headerLocalizationDomain]]]])}}. Example: ${{Structr.to_csv(Structr.find('Page'), 'ui'))}}";

    public String getName() {
        return "to_csv()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 8)) {
                if (!(sources[0] instanceof List)) {
                    this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                    return "ERROR: First parameter must be a collection!".concat(this.usage(ctx.isJavaScriptContext()));
                }
                List nodes = (List)sources[0];
                String delimiterChar = ";";
                String quoteChar = "\"";
                String recordSeparator = "\n";
                boolean includeHeader = true;
                boolean localizeHeader = false;
                String headerLocalizationDomain = null;
                String propertyView = null;
                List properties = null;
                if (nodes.size() == 0) {
                    logger.warn("to_csv(): Can not create CSV if no nodes are given!");
                    this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                    return "";
                }
                switch (sources.length) {
                    case 8: {
                        headerLocalizationDomain = (String)sources[7];
                    }
                    case 7: {
                        localizeHeader = (Boolean)sources[6];
                    }
                    case 6: {
                        includeHeader = (Boolean)sources[5];
                    }
                    case 5: {
                        recordSeparator = (String)sources[4];
                    }
                    case 4: {
                        quoteChar = (String)sources[3];
                    }
                    case 3: {
                        delimiterChar = (String)sources[2];
                    }
                    case 2: {
                        if (sources[1] instanceof String) {
                            propertyView = (String)sources[1];
                            break;
                        }
                        if (sources[1] instanceof List) {
                            properties = (List)sources[1];
                            if (properties.size() != 0) break;
                            logger.warn("to_csv(): Can not create CSV if list of properties is empty!");
                            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                            return "";
                        }
                        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                        return "ERROR: Second parameter must be a collection of property names or a single property view!".concat(this.usage(ctx.isJavaScriptContext()));
                    }
                }
                try {
                    StringWriter writer = new StringWriter();
                    ToCsvFunction.writeCsv(nodes, (Writer)writer, propertyView, (List<String>)properties, quoteChar.charAt(0), delimiterChar.charAt(0), recordSeparator, includeHeader, localizeHeader, headerLocalizationDomain, ctx.getLocale());
                    return writer.toString();
                }
                catch (Throwable t) {
                    logger.warn("to_csv(): Exception occurred", t);
                    return "";
                }
            }
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TO_CSV_JS : ERROR_MESSAGE_TO_CSV;
    }

    public String shortDescription() {
        return "Returns a CSV representation of the given nodes";
    }

    public static void writeCsv(Result result, Writer out, String propertyView, List<String> properties, char quoteChar, char delimiterChar, String recordSeparator, boolean includeHeader, boolean localizeHeader, String headerLocalizationDomain, Locale locale) throws IOException {
        List list = result.getResults();
        ToCsvFunction.writeCsv(list, out, propertyView, properties, quoteChar, delimiterChar, recordSeparator, includeHeader, localizeHeader, headerLocalizationDomain, locale);
    }

    public static void writeCsv(List list, Writer out, String propertyView, List<String> properties, char quoteChar, char delimiterChar, String recordSeparator, boolean includeHeader, boolean localizeHeader, String headerLocalizationDomain, Locale locale) throws IOException {
        StringBuilder row = new StringBuilder();
        if (includeHeader) {
            row.setLength(0);
            boolean isFirstCol = true;
            if (propertyView != null) {
                Object obj = list.get(0);
                if (obj instanceof GraphObject) {
                    for (PropertyKey key : ((GraphObject)obj).getPropertyKeys(propertyView)) {
                        String value = key.dbName();
                        if (localizeHeader) {
                            try {
                                value = LocalizeFunction.getLocalization((Locale)locale, (String)value, (String)headerLocalizationDomain);
                            }
                            catch (FrameworkException fex) {
                                logger.warn("to_csv(): Exception", (Throwable)fex);
                            }
                        }
                        isFirstCol = ToCsvFunction.appendColumnString(row, value, isFirstCol, quoteChar, delimiterChar);
                    }
                } else {
                    row.append("Error: Object is not of type GraphObject, can not determine properties of view for header row");
                }
            } else if (properties != null) {
                for (String colName : properties) {
                    Object value = colName;
                    if (localizeHeader) {
                        try {
                            value = LocalizeFunction.getLocalization((Locale)locale, (String)value, (String)headerLocalizationDomain);
                        }
                        catch (FrameworkException fex) {
                            logger.warn("to_csv(): Exception", (Throwable)fex);
                        }
                    }
                    isFirstCol = ToCsvFunction.appendColumnString(row, value, isFirstCol, quoteChar, delimiterChar);
                }
            }
            out.append(row).append(recordSeparator).flush();
        }
        for (Object obj : list) {
            row.setLength(0);
            boolean isFirstCol = true;
            if (propertyView != null) {
                if (obj instanceof GraphObject) {
                    for (PropertyKey key : ((GraphObject)obj).getPropertyKeys(propertyView)) {
                        Object value = ((GraphObject)obj).getProperty(key);
                        isFirstCol = ToCsvFunction.appendColumnString(row, value, isFirstCol, quoteChar, delimiterChar);
                    }
                } else {
                    row.append("Error: Object is not of type GraphObject, can not determine properties of object");
                }
            } else if (properties != null) {
                Object castedObj;
                if (obj instanceof GraphObject) {
                    castedObj = (GraphObject)obj;
                    for (String colName : properties) {
                        PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(obj.getClass(), colName);
                        Object value = castedObj.getProperty(key);
                        isFirstCol = ToCsvFunction.appendColumnString(row, value, isFirstCol, quoteChar, delimiterChar);
                    }
                } else if (obj instanceof Map) {
                    castedObj = (Map)obj;
                    for (String colName : properties) {
                        Object value = castedObj.get(colName);
                        isFirstCol = ToCsvFunction.appendColumnString(row, value, isFirstCol, quoteChar, delimiterChar);
                    }
                }
            }
            String rowWithoutRecordSeparator = row.toString().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
            out.append(rowWithoutRecordSeparator).append(recordSeparator).flush();
        }
    }

    private static boolean appendColumnString(StringBuilder row, Object value, boolean isFirstColumn, char quoteChar, char delimiter) {
        if (!isFirstColumn) {
            row.append(delimiter);
        }
        row.append(ToCsvFunction.escapeForCsv(value, quoteChar));
        return false;
    }

    private static String escapeForCsv(Object value, char quoteChar) {
        String result;
        if (value == null) {
            result = "";
        } else if (value instanceof String[]) {
            ArrayList<String> quotedStrings = new ArrayList<String>();
            for (String str : Arrays.asList((String[])value)) {
                quotedStrings.add("\\" + quoteChar + StringUtils.replace((String)str, (String)("" + quoteChar), (String)("\\\\\\" + quoteChar)) + "\\" + quoteChar);
            }
            result = quotedStrings.toString();
        } else if (value instanceof Collection) {
            ArrayList<String> quotedStrings = new ArrayList<String>();
            for (Object obj : (Collection)value) {
                quotedStrings.add("\\" + quoteChar + obj.toString() + "\\" + quoteChar);
            }
            result = quotedStrings.toString();
        } else {
            result = value instanceof Date ? DatePropertyParser.format((Date)((Date)value), (String)DateProperty.getDefaultFormat()) : StringUtils.replace((String)value.toString(), (String)("" + quoteChar), (String)("\\" + quoteChar));
        }
        return "".concat("" + quoteChar).concat(StringUtils.replace((String)StringUtils.replace((String)result, (String)"\r\n", (String)"\\n"), (String)"\r", (String)"\\n")).concat("" + quoteChar);
    }
}

