/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.TreeSet;
import org.python.icu.impl.CalendarData;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.lang.UCharacter;
import org.python.icu.text.BreakIterator;
import org.python.icu.text.DateFormat;
import org.python.icu.text.DisplayContext;
import org.python.icu.text.MessageFormat;
import org.python.icu.text.SimpleDateFormat;
import org.python.icu.util.Calendar;
import org.python.icu.util.TimeZone;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;
import org.python.icu.util.UResourceBundleIterator;

public class RelativeDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1131984966440549435L;
    private DateFormat fDateFormat;
    private DateFormat fTimeFormat;
    private MessageFormat fCombinedFormat;
    private SimpleDateFormat fDateTimeFormat = null;
    private String fDatePattern = null;
    private String fTimePattern = null;
    int fDateStyle;
    int fTimeStyle;
    ULocale fLocale;
    private transient URelativeString[] fDates = null;
    private boolean combinedFormatHasDateAtStart = false;
    private boolean capitalizationInfoIsSet = false;
    private boolean capitalizationOfRelativeUnitsForListOrMenu = false;
    private boolean capitalizationOfRelativeUnitsForStandAlone = false;
    private transient BreakIterator capitalizationBrkIter = null;

    public RelativeDateFormat(int timeStyle, int dateStyle, ULocale locale2, Calendar cal) {
        this.calendar = cal;
        this.fLocale = locale2;
        this.fTimeStyle = timeStyle;
        this.fDateStyle = dateStyle;
        if (this.fDateStyle != -1) {
            int newStyle = this.fDateStyle & 0xFFFFFF7F;
            DateFormat df = DateFormat.getDateInstance(newStyle, locale2);
            if (!(df instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("Can't create SimpleDateFormat for date style");
            }
            this.fDateTimeFormat = (SimpleDateFormat)df;
            this.fDatePattern = this.fDateTimeFormat.toPattern();
            if (this.fTimeStyle != -1 && (df = DateFormat.getTimeInstance(newStyle = this.fTimeStyle & 0xFFFFFF7F, locale2)) instanceof SimpleDateFormat) {
                this.fTimePattern = ((SimpleDateFormat)df).toPattern();
            }
        } else {
            int newStyle = this.fTimeStyle & 0xFFFFFF7F;
            DateFormat df = DateFormat.getTimeInstance(newStyle, locale2);
            if (!(df instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("Can't create SimpleDateFormat for time style");
            }
            this.fDateTimeFormat = (SimpleDateFormat)df;
            this.fTimePattern = this.fDateTimeFormat.toPattern();
        }
        this.initializeCalendar(null, this.fLocale);
        this.loadDates();
        this.initializeCombinedFormat(this.calendar, this.fLocale);
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        String relativeDayString = null;
        DisplayContext capitalizationContext = this.getContext(DisplayContext.Type.CAPITALIZATION);
        if (this.fDateStyle != -1) {
            int dayDiff = RelativeDateFormat.dayDifference(cal);
            relativeDayString = this.getStringForDay(dayDiff);
        }
        if (this.fDateTimeFormat != null) {
            if (relativeDayString != null && this.fDatePattern != null && (this.fTimePattern == null || this.fCombinedFormat == null || this.combinedFormatHasDateAtStart)) {
                if (relativeDayString.length() > 0 && UCharacter.isLowerCase(relativeDayString.codePointAt(0)) && (capitalizationContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || capitalizationContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationOfRelativeUnitsForListOrMenu || capitalizationContext == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationOfRelativeUnitsForStandAlone)) {
                    if (this.capitalizationBrkIter == null) {
                        this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.fLocale);
                    }
                    relativeDayString = UCharacter.toTitleCase(this.fLocale, relativeDayString, this.capitalizationBrkIter, 768);
                }
                this.fDateTimeFormat.setContext(DisplayContext.CAPITALIZATION_NONE);
            } else {
                this.fDateTimeFormat.setContext(capitalizationContext);
            }
        }
        if (this.fDateTimeFormat != null && (this.fDatePattern != null || this.fTimePattern != null)) {
            if (this.fDatePattern == null) {
                this.fDateTimeFormat.applyPattern(this.fTimePattern);
                this.fDateTimeFormat.format(cal, toAppendTo, fieldPosition);
            } else if (this.fTimePattern == null) {
                if (relativeDayString != null) {
                    toAppendTo.append(relativeDayString);
                } else {
                    this.fDateTimeFormat.applyPattern(this.fDatePattern);
                    this.fDateTimeFormat.format(cal, toAppendTo, fieldPosition);
                }
            } else {
                String datePattern = this.fDatePattern;
                if (relativeDayString != null) {
                    datePattern = "'" + relativeDayString.replace("'", "''") + "'";
                }
                StringBuffer combinedPattern = new StringBuffer("");
                this.fCombinedFormat.format(new Object[]{this.fTimePattern, datePattern}, combinedPattern, new FieldPosition(0));
                this.fDateTimeFormat.applyPattern(combinedPattern.toString());
                this.fDateTimeFormat.format(cal, toAppendTo, fieldPosition);
            }
        } else if (this.fDateFormat != null) {
            if (relativeDayString != null) {
                toAppendTo.append(relativeDayString);
            } else {
                this.fDateFormat.format(cal, toAppendTo, fieldPosition);
            }
        }
        return toAppendTo;
    }

    public void parse(String text2, Calendar cal, ParsePosition pos) {
        throw new UnsupportedOperationException("Relative Date parse is not implemented yet");
    }

    public void setContext(DisplayContext context) {
        super.setContext(context);
        if (!(this.capitalizationInfoIsSet || context != DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && context != DisplayContext.CAPITALIZATION_FOR_STANDALONE)) {
            this.initCapitalizationContextInfo(this.fLocale);
            this.capitalizationInfoIsSet = true;
        }
        if (this.capitalizationBrkIter == null && (context == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || context == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationOfRelativeUnitsForListOrMenu || context == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationOfRelativeUnitsForStandAlone)) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.fLocale);
        }
    }

    private String getStringForDay(int day) {
        if (this.fDates == null) {
            this.loadDates();
        }
        for (int i = 0; i < this.fDates.length; ++i) {
            if (this.fDates[i].offset != day) continue;
            return this.fDates[i].string;
        }
        return null;
    }

    private synchronized void loadDates() {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", this.fLocale);
        ICUResourceBundle rdb = rb.getWithFallback("fields/day/relative");
        TreeSet<URelativeString> datesSet = new TreeSet<URelativeString>(new Comparator<URelativeString>(){

            @Override
            public int compare(URelativeString r1, URelativeString r2) {
                if (r1.offset == r2.offset) {
                    return 0;
                }
                if (r1.offset < r2.offset) {
                    return -1;
                }
                return 1;
            }
        });
        UResourceBundleIterator i = rdb.getIterator();
        while (i.hasNext()) {
            UResourceBundle line = i.next();
            String k = line.getKey();
            String v = line.getString();
            URelativeString rs = new URelativeString(k, v);
            datesSet.add(rs);
        }
        this.fDates = datesSet.toArray(new URelativeString[0]);
    }

    private void initCapitalizationContextInfo(ULocale locale2) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", locale2);
        try {
            ICUResourceBundle rdb = rb.getWithFallback("contextTransforms/relative");
            int[] intVector = rdb.getIntVector();
            if (intVector.length >= 2) {
                this.capitalizationOfRelativeUnitsForListOrMenu = intVector[0] != 0;
                this.capitalizationOfRelativeUnitsForStandAlone = intVector[1] != 0;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static int dayDifference(Calendar until) {
        Calendar nowCal = (Calendar)until.clone();
        Date nowDate = new Date(System.currentTimeMillis());
        nowCal.clear();
        nowCal.setTime(nowDate);
        int dayDiff = until.get(20) - nowCal.get(20);
        return dayDiff;
    }

    private Calendar initializeCalendar(TimeZone zone, ULocale locale2) {
        if (this.calendar == null) {
            this.calendar = zone == null ? Calendar.getInstance(locale2) : Calendar.getInstance(zone, locale2);
        }
        return this.calendar;
    }

    private MessageFormat initializeCombinedFormat(Calendar cal, ULocale locale2) {
        String pattern = "{1} {0}";
        try {
            CalendarData calData = new CalendarData(locale2, cal.getType());
            String[] patterns = calData.getDateTimePatterns();
            if (patterns != null && patterns.length >= 9) {
                int glueIndex = 8;
                if (patterns.length >= 13) {
                    switch (this.fDateStyle) {
                        case 0: 
                        case 128: {
                            ++glueIndex;
                            break;
                        }
                        case 1: 
                        case 129: {
                            glueIndex += 2;
                            break;
                        }
                        case 2: 
                        case 130: {
                            glueIndex += 3;
                            break;
                        }
                        case 3: 
                        case 131: {
                            glueIndex += 4;
                            break;
                        }
                    }
                }
                pattern = patterns[glueIndex];
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.combinedFormatHasDateAtStart = pattern.startsWith("{1}");
        this.fCombinedFormat = new MessageFormat(pattern, locale2);
        return this.fCombinedFormat;
    }

    public static class URelativeString {
        public int offset;
        public String string;

        URelativeString(int offset, String string2) {
            this.offset = offset;
            this.string = string2;
        }

        URelativeString(String offset, String string2) {
            this.offset = Integer.parseInt(offset);
            this.string = string2;
        }
    }
}

