/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net;

import java.util.LinkedHashSet;
import java.util.Set;
import org.structr.api.service.LicenseManager;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.PropertyKey;
import org.structr.module.StructrModule;
import org.structr.schema.action.Actions;

public class PeerToPeerModule
implements StructrModule {
    public void onLoad(LicenseManager licenseManager) {
    }

    public String getName() {
        return "peer-to-peer";
    }

    public Set<String> getDependencies() {
        return null;
    }

    public Set<String> getFeatures() {
        return null;
    }

    public void insertImportStatements(AbstractSchemaNode abstractSchemaNode, StringBuilder stringBuilder) {
        if (this.isShared(abstractSchemaNode)) {
            stringBuilder.append("import org.structr.net.SharedNodeInterface;\n");
        }
    }

    public Set<String> getInterfacesForType(AbstractSchemaNode abstractSchemaNode) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.isShared(abstractSchemaNode)) {
            linkedHashSet.add("SharedNodeInterface");
        }
        return linkedHashSet;
    }

    public void insertSaveAction(AbstractSchemaNode abstractSchemaNode, StringBuilder stringBuilder, Actions.Type type) {
        if (this.isShared(abstractSchemaNode)) {
            switch (type) {
                case Create: {
                    stringBuilder.append("\n");
                    stringBuilder.append("\t\tfinal org.structr.net.PeerToPeerService service = getService();\n");
                    stringBuilder.append("\t\tif (service != null) {\n");
                    stringBuilder.append("\n");
                    stringBuilder.append("\t\t\tfinal org.structr.net.data.time.PseudoTime time = service.getTime();\n");
                    stringBuilder.append("\n");
                    stringBuilder.append("\t\t\tsuper.setProperty(lastModifiedPseudoTime, time.toString());\n");
                    stringBuilder.append("\t\t\tsuper.setProperty(createdPseudoTime,      time.toString());\n");
                    stringBuilder.append("\t\t}\n");
                    stringBuilder.append("\n");
                    break;
                }
                case Save: {
                    stringBuilder.append("\n");
                    stringBuilder.append("\t\tfinal org.structr.net.PeerToPeerService service = getService();\n");
                    stringBuilder.append("\t\tif (service != null) {\n");
                    stringBuilder.append("\n");
                    stringBuilder.append("\t\t\tservice.update(this);\n");
                    stringBuilder.append("\t\t}\n");
                    stringBuilder.append("\n");
                    break;
                }
            }
        }
    }

    public void insertSourceCode(AbstractSchemaNode abstractSchemaNode, StringBuilder stringBuilder) {
        if (this.isShared(abstractSchemaNode)) {
            stringBuilder.append("\tprivate boolean fullyCreated = false;\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t@Override\n");
            stringBuilder.append("\tpublic void onNodeInstantiation(final boolean isCreation) {\n");
            stringBuilder.append("\t\tfullyCreated = !isCreation;\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tpublic Map<String, Object> getData() {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfinal Set<PropertyKey> keys    = new LinkedHashSet<>(StructrApp.getConfiguration().getPropertySet(entityType, \"shared\"));\n");
            stringBuilder.append("\t\tfinal Map<String, Object> data = new HashMap<>();\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tkeys.removeAll(nativeKeys);\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfor (final PropertyKey key : keys) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tfinal PropertyConverter converter = key.inputConverter(securityContext);\n");
            stringBuilder.append("\t\t\tObject value = convert(getProperty(key));\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tif (converter != null && !(value instanceof String)) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\ttry {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t\tvalue = converter.revert(value);\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t} catch (FrameworkException fex) {\n");
            stringBuilder.append("\t\t\t\t\tfex.printStackTrace();\n");
            stringBuilder.append("\t\t\t\t}\n");
            stringBuilder.append("\t\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tdata.put(key.jsonName(), value);\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\treturn data;\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t@Override\n");
            stringBuilder.append("\tpublic void afterCreation(SecurityContext securityContext) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfullyCreated = true;\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfinal org.structr.net.PeerToPeerService service = getService();\n");
            stringBuilder.append("\t\tif (service != null) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tservice.create(this);\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t@Override\n");
            stringBuilder.append("\tpublic void afterDeletion(final SecurityContext securityContext, final PropertyMap properties) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfinal org.structr.net.PeerToPeerService service = getService();\n");
            stringBuilder.append("\t\tif (service != null) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tservice.delete(properties.get(GraphObject.id));\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t@Override\n");
            stringBuilder.append("\tpublic <T> Object setProperty(final PropertyKey<T> key, final T value) throws FrameworkException {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tif (fullyCreated) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tfinal org.structr.net.PeerToPeerService service = getService();\n");
            stringBuilder.append("\t\t\tif (service != null) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\tservice.setProperty(getProperty(GraphObject.id), key.jsonName(), convert(value));\n");
            stringBuilder.append("\t\t\t}\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\treturn super.setProperty(key, value);\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tpublic org.structr.net.data.time.PseudoTime getCreationPseudoTime() {\n");
            stringBuilder.append("\t\treturn org.structr.net.data.time.PseudoTime.fromString(getProperty(createdPseudoTime));\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tpublic org.structr.net.data.time.PseudoTime getLastModificationPseudoTime() {\n");
            stringBuilder.append("\t\treturn org.structr.net.data.time.PseudoTime.fromString(getProperty(lastModifiedPseudoTime));\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tpublic void setProperty(final org.structr.core.app.App app, final PropertyKey key, final Object rawValue) throws FrameworkException {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfinal PropertyConverter inputConverter = key.inputConverter(securityContext);\n");
            stringBuilder.append("\t\tObject value                           = revert(app, rawValue);\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tif (inputConverter != null) {\n");
            stringBuilder.append("\t\t\tvalue = inputConverter.convert(value);\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tsuper.setProperty(key, value);\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tpublic String getUserId() {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tfinal Principal owner = getOwnerNode();\n");
            stringBuilder.append("\t\tif (owner != null) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\treturn owner.getName();\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\treturn Principal.SUPERUSER_ID;\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t// ----- private methods -----\n");
            stringBuilder.append("\tprivate org.structr.net.PeerToPeerService getService() {\n");
            stringBuilder.append("\t\treturn Services.getInstance().getService(org.structr.net.PeerToPeerService.class);\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tprivate Object convert(final Object value) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tObject result = value;\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tif (value instanceof GraphObject) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tresult = \"!\" + ((GraphObject)value).getUuid();\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t} else if (value instanceof Collection) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tfinal List<Object> list = new LinkedList<>();\n");
            stringBuilder.append("\t\t\tfor (final Object item : ((Collection)value)) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t// recurse\n");
            stringBuilder.append("\t\t\t\tlist.add(convert(item));\n");
            stringBuilder.append("\t\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tresult = \"#\" + StringUtils.join(list, \",\");\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\treturn result;\n");
            stringBuilder.append("\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\tprivate Object revert(final org.structr.core.app.App app, final Object value) throws FrameworkException {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tObject result = value;\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\tif (value instanceof String) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tfinal String str = (String)value;\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\tif (str.startsWith(\"#\")) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\tif (str.length() > 1) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t\tfinal String[] parts    = str.substring(1).split(\"[,]+\");\n");
            stringBuilder.append("\t\t\t\t\tfinal List<Object> list = new LinkedList<>();\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t\tfor (final String part : parts) {\n");
            stringBuilder.append("\t\t\t\t\t\tlist.add(revert(app, part));\n");
            stringBuilder.append("\t\t\t\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t\tresult = list;\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t} else {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\t\tresult = Collections.emptyList();\n");
            stringBuilder.append("\t\t\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t} else if (str.startsWith(\"!\") && str.length() == 33) {\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t\tresult = app.get(str.substring(1));\n");
            stringBuilder.append("\t\t\t}\n");
            stringBuilder.append("\t\t}\n");
            stringBuilder.append("\n");
            stringBuilder.append("\t\treturn result;\n");
            stringBuilder.append("\t}\n");
        }
    }

    private boolean isShared(AbstractSchemaNode abstractSchemaNode) {
        return Boolean.TRUE.equals(abstractSchemaNode.getProperty((PropertyKey)SchemaNode.shared));
    }
}

