/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyPair;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.net.SharedNodeInterface;
import org.structr.net.common.KeyHelper;
import org.structr.net.data.RemoteTransaction;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.repository.DefaultRepository;
import org.structr.net.repository.ExternalChangeListener;
import org.structr.net.repository.ObjectListener;
import org.structr.net.repository.Repository;
import org.structr.net.repository.RepositoryObject;
import org.structr.schema.ConfigurationProvider;

public class PeerToPeerService
implements RunnableService,
ExternalChangeListener {
    public static final String PEER_UUID_KEY = "peer.config.uuid";
    public static final String INITIAL_PEER_KEY = "peer.config.initial.peer";
    public static final String BIND_ADDRESS_KEY = "peer.config.bind.address";
    public static final String VERBOSE_KEY = "peer.config.verbose";
    public static final String PUBLIC_KEY_CONFIG_KEY = "peer.key.public.file";
    public static final String PRIVATE_KEY_CONFIG_KEY = "peer.key.private.file";
    private static final Logger logger = LoggerFactory.getLogger((String)PeerToPeerService.class.getName());
    private DefaultRepository repository = null;
    private boolean initialized = false;
    private Peer peer = null;

    public void startService() {
        if (this.initialized) {
            this.peer.start();
            logger.info("Service started");
        }
    }

    public void stopService() {
        if (this.initialized) {
            this.peer.stop();
        }
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.initialized && this.peer.isRunning();
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices structrServices) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.info("Initializing..");
        try {
            KeyPair keyPair = this.getOrCreateKeyPair();
            if (keyPair != null) {
                String string = (String)Settings.getOrCreateStringSetting((String[])new String[]{INITIAL_PEER_KEY, "255.255.255.255"}).getValue();
                String string2 = (String)Settings.getOrCreateStringSetting((String[])new String[]{BIND_ADDRESS_KEY, "0.0.0.0"}).getValue();
                String string3 = (String)Settings.getOrCreateStringSetting((String[])new String[]{PEER_UUID_KEY, StructrApp.getInstance().getInstanceId()}).getValue();
                boolean bl = (Boolean)Settings.getBooleanSetting((String[])new String[]{VERBOSE_KEY}).getValue();
                logger.info("{}: {}", new Object[]{BIND_ADDRESS_KEY, string2});
                logger.info("{}: {}", new Object[]{INITIAL_PEER_KEY, string});
                logger.info("{}: {}", new Object[]{PRIVATE_KEY_CONFIG_KEY, Settings.getOrCreateStringSetting((String[])new String[]{PRIVATE_KEY_CONFIG_KEY}).getValue()});
                logger.info("{}: {}", new Object[]{PUBLIC_KEY_CONFIG_KEY, Settings.getOrCreateStringSetting((String[])new String[]{PUBLIC_KEY_CONFIG_KEY}).getValue()});
                logger.info("{}: {}", new Object[]{PEER_UUID_KEY, string3});
                logger.info("{}: {}", new Object[]{VERBOSE_KEY, bl});
                this.repository = new DefaultRepository(string3);
                this.peer = new Peer(this.getOrCreateKeyPair(), (Repository)this.repository, string2, string);
                this.peer.initializeServer();
                this.peer.setVerbose(bl);
                this.repository.addExternalChangeListener((ExternalChangeListener)this);
                this.repository.setPeer(this.peer);
                this.initialized = true;
            }
        }
        catch (Throwable throwable) {
            logger.warn("Unable to initialize PeerToPeerService", throwable);
        }
    }

    public void shutdown() {
        if (this.initialized) {
            this.peer.stop();
        }
    }

    public void initialized() {
    }

    public String getName() {
        return PeerToPeerService.class.getSimpleName();
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "peer-to-peer";
    }

    public void create(SharedNodeInterface sharedNodeInterface) {
        String string = sharedNodeInterface.getUuid();
        String string2 = sharedNodeInterface.getType();
        String string3 = sharedNodeInterface.getUserId();
        PseudoTime pseudoTime = sharedNodeInterface.getCreationPseudoTime();
        logger.info("Shared node with UUID {} CREATED in Structr at {}", new Object[]{sharedNodeInterface.getUuid(), pseudoTime.toString()});
        this.repository.create(string, string2, this.peer.getUuid(), string3, pseudoTime, sharedNodeInterface.getData());
    }

    public void delete(String string) {
        PseudoTime pseudoTime = this.peer.getPseudoTemporalEnvironment().current();
        logger.info("Shared node with UUID {} DELETED in Structr at {}", new Object[]{string, pseudoTime});
        this.repository.delete(string, pseudoTime);
    }

    public void update(SharedNodeInterface sharedNodeInterface) {
        RepositoryObject repositoryObject = this.repository.getObject(sharedNodeInterface.getUuid());
        if (repositoryObject != null) {
            PseudoTime pseudoTime = sharedNodeInterface.getLastModificationPseudoTime();
            Map<String, Object> map = sharedNodeInterface.getData();
            String string = sharedNodeInterface.getType();
            String string2 = sharedNodeInterface.getUserId();
            logger.info("Shared node with UUID {} UPDATED in Structr at {}", new Object[]{sharedNodeInterface.getUuid(), pseudoTime.toString()});
            this.repository.update(repositoryObject, string, this.peer.getUuid(), string2, pseudoTime, map);
        }
    }

    public void setProperty(String string, String string2, Object object) throws FrameworkException {
        block15: {
            logger.info("Attempting to modify shared node with UUID {}: {} = {} in Structr", new Object[]{string, string2, object});
            RepositoryObject repositoryObject = this.repository.getObject(string);
            if (repositoryObject != null) {
                try (RemoteTransaction remoteTransaction = this.peer.beginTx(repositoryObject);){
                    remoteTransaction.setProperty(repositoryObject, string2, object);
                    remoteTransaction.commit();
                    break block15;
                }
                catch (Exception exception) {
                    System.out.println("timeout");
                    throw new FrameworkException(500, exception.getMessage());
                }
            }
            System.out.println("No such object " + string);
        }
    }

    public void addObjectToRepository(SharedNodeInterface sharedNodeInterface) {
        String string = (String)sharedNodeInterface.getProperty((PropertyKey)GraphObject.id);
        String string2 = (String)sharedNodeInterface.getProperty((PropertyKey)GraphObject.type);
        PseudoTime pseudoTime = sharedNodeInterface.getLastModificationPseudoTime();
        PseudoTime pseudoTime2 = sharedNodeInterface.getCreationPseudoTime();
        String string3 = NodeServiceCommand.getNextUuid();
        RepositoryObject repositoryObject = this.repository.add(string, string2, this.peer.getUuid(), sharedNodeInterface.getUserId(), pseudoTime2);
        for (Map.Entry<String, Object> entry : sharedNodeInterface.getData().entrySet()) {
            repositoryObject.setProperty(pseudoTime, string3, entry.getKey(), entry.getValue());
        }
        this.repository.complete(string3);
        repositoryObject.addListener((ObjectListener)new ObjectUpdater(string));
    }

    public PseudoTime getTime() {
        return this.peer.getPseudoTemporalEnvironment().next();
    }

    public void onQuery() {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            LinkedHashMap<String, SharedNodeInterface> linkedHashMap = new LinkedHashMap<String, SharedNodeInterface>();
            for (SharedNodeInterface sharedNodeInterface : app.nodeQuery(SharedNodeInterface.class).getAsList()) {
                linkedHashMap.put(sharedNodeInterface.getUuid(), sharedNodeInterface);
            }
            if (linkedHashMap.size() != this.repository.objectCount()) {
                logger.info("Rebuilding list of shared objects: {} vs. {}", new Object[]{linkedHashMap.size(), this.repository.objectCount()});
                this.repository.clear();
                for (SharedNodeInterface sharedNodeInterface : linkedHashMap.values()) {
                    this.addObjectToRepository(sharedNodeInterface);
                }
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    public void onCreate(RepositoryObject repositoryObject, Map<String, Object> map) {
        logger.info("New object with UUID {} created in repository", (Object)repositoryObject.getUuid());
        ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
        Class clazz = configurationProvider.getNodeEntityClass(repositoryObject.getType());
        if (clazz != null) {
            App app = StructrApp.getInstance((SecurityContext)this.getUserContext(repositoryObject));
            try (Tx tx = app.tx();){
                SharedNodeInterface sharedNodeInterface = (SharedNodeInterface)app.create(clazz, new NodeAttribute[]{new NodeAttribute((PropertyKey)GraphObject.id, (Object)repositoryObject.getUuid()), new NodeAttribute(SharedNodeInterface.lastModifiedPseudoTime, (Object)repositoryObject.getLastModificationTime().toString()), new NodeAttribute(SharedNodeInterface.createdPseudoTime, (Object)repositoryObject.getCreationTime().toString())});
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, entry.getKey(), false);
                    if (propertyKey == null) continue;
                    sharedNodeInterface.setProperty(app, propertyKey, entry.getValue());
                }
                repositoryObject.addListener((ObjectListener)new ObjectUpdater(repositoryObject.getUuid()));
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                logger.warn("", (Throwable)frameworkException);
            }
        } else {
            System.out.println("Type " + repositoryObject.getType() + " not found, NOT creating object with ID " + repositoryObject.getUuid());
        }
    }

    public void onDelete(RepositoryObject repositoryObject) {
        App app = StructrApp.getInstance((SecurityContext)this.getUserContext(repositoryObject));
        try (Tx tx = app.tx();){
            SharedNodeInterface sharedNodeInterface = (SharedNodeInterface)app.get(SharedNodeInterface.class, repositoryObject.getUuid());
            if (sharedNodeInterface != null) {
                app.delete((NodeInterface)sharedNodeInterface);
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    public void onModify(RepositoryObject repositoryObject, Map<String, Object> map) {
    }

    public void onAdd() {
    }

    public void onRemove() {
    }

    private SecurityContext getUserContext(RepositoryObject repositoryObject) {
        String string = repositoryObject.getUserId();
        Principal principal = null;
        if (string != null) {
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                principal = (Principal)app.nodeQuery(Principal.class).and((PropertyKey)Principal.name, (Object)string).getFirst();
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                logger.warn("", (Throwable)frameworkException);
            }
        } else {
            System.out.println("Object without userId!");
        }
        if (principal != null) {
            return SecurityContext.getInstance(principal, (AccessMode)AccessMode.Backend);
        }
        return SecurityContext.getSuperUserInstance();
    }

    private KeyPair getOrCreateKeyPair() {
        String string = (String)Settings.getOrCreateStringSetting((String[])new String[]{PRIVATE_KEY_CONFIG_KEY}).getValue();
        String string2 = (String)Settings.getOrCreateStringSetting((String[])new String[]{PUBLIC_KEY_CONFIG_KEY}).getValue();
        if (string == null) {
            logger.warn("No private key file name set for PeerToPeerService, aborting. Please set a value for {} in structr.conf.", (Object)PRIVATE_KEY_CONFIG_KEY);
            return null;
        }
        if (string2 == null) {
            logger.warn("No public key file name set for PeerToPeerService, aborting. Please set  value for {} in structr.conf.", (Object)PUBLIC_KEY_CONFIG_KEY);
            return null;
        }
        try {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.exists()) {
                logger.warn("Private key file {} not found, aborting.", (Object)string);
                return null;
            }
            if (!file2.exists()) {
                logger.warn("Public key file {} not found, aborting.", (Object)string2);
                return null;
            }
            String string3 = this.getKey(Files.readAllLines(file.toPath()));
            String string4 = this.getKey(Files.readAllLines(file2.toPath()));
            if (string3 == null || string3.isEmpty()) {
                logger.warn("No private key found in file {}, aborting", (Object)string);
                return null;
            }
            if (string4 == null || string4.isEmpty()) {
                logger.warn("No public key found in file {}, aborting", (Object)string2);
                return null;
            }
            Base64.Decoder decoder = Base64.getDecoder();
            return KeyHelper.fromBytes((String)"RSA", (byte[])decoder.decode(string3), (byte[])decoder.decode(string4));
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
            return null;
        }
    }

    private String getKey(List<String> list) {
        for (String string : list) {
            if (string.contains("#")) {
                String string2 = string.substring(0, string.indexOf("#"));
                if (string2.isEmpty()) continue;
                return string2;
            }
            if (string.isEmpty()) continue;
            return string;
        }
        return null;
    }

    private class ObjectUpdater
    implements ObjectListener {
        private String uuid = null;

        public ObjectUpdater(String string) {
            this.uuid = string;
        }

        public void onPropertyChange(RepositoryObject repositoryObject, String string, Object object) {
            ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
            App app = StructrApp.getInstance((SecurityContext)PeerToPeerService.this.getUserContext(repositoryObject));
            try (Tx tx = app.tx();){
                SharedNodeInterface sharedNodeInterface = (SharedNodeInterface)app.get(SharedNodeInterface.class, this.uuid);
                if (sharedNodeInterface != null) {
                    PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(sharedNodeInterface.getClass(), string, false);
                    if (propertyKey != null) {
                        sharedNodeInterface.setProperty(app, propertyKey, object);
                    }
                    sharedNodeInterface.setProperty(app, (PropertyKey)SharedNodeInterface.lastModifiedPseudoTime, repositoryObject.getLastModificationTime().toString());
                    tx.success();
                }
            }
            catch (FrameworkException frameworkException) {
                logger.warn("", (Throwable)frameworkException);
            }
        }
    }
}

