/**
 * Copyright (C) 2010-2017 Structr GmbH
 *
 * This file is part of Structr <http://structr.org>.
 *
 * Structr is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * Structr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Structr.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.structr.websocket.command;


import java.util.LinkedList;
import java.util.Map;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch.Patch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.Content;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

//~--- classes ----------------------------------------------------------------

/**
 *
 *
 */
public class PatchCommand extends AbstractCommand {

	private static final Logger logger = LoggerFactory.getLogger(PatchCommand.class.getName());

	static {
		StructrWebSocket.addCommand(PatchCommand.class);
	}

	//~--- methods --------------------------------------------------------

	@Override
	public void processMessage(final WebSocketMessage webSocketData) {

		final AbstractNode node        = getNode(webSocketData.getId());
		Map<String, Object> properties = webSocketData.getNodeData();
		String patch                   = (String) properties.get("patch");

		if (node != null) {

			final DiffMatchPatch dmp        = new DiffMatchPatch();
			final String oldText            = node.getProperty(Content.content);
			final LinkedList<Patch> patches = new LinkedList<>(dmp.patchFromText(patch));
			final Object[] results          = dmp.patchApply(patches, oldText);

			try {
				node.setProperties(node.getSecurityContext(), new PropertyMap(Content.content, results[0].toString()));

				TransactionCommand.registerNodeCallback(node, callback);

			} catch (Throwable t) {

				logger.warn("Could not apply patch {}", patch);
				getWebSocket().send(MessageBuilder.status().code(400).message("Could not apply patch. " + t.getMessage()).build(), true);

			}

		} else {

			logger.warn("Node with uuid {} not found.", webSocketData.getId());
			getWebSocket().send(MessageBuilder.status().code(404).message("Node with uuid " + webSocketData.getId() + " not found.").build(), true);

		}

	}

	//~--- get methods ----------------------------------------------------

	@Override
	public String getCommand() {

		return "PATCH";

	}

}
